/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.network.messages;

import com.mojang.authlib.GameProfile;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.compat.argonauts.ArgonautsIntegration;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.SpaceStationHandler;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.network.CodecPacketType;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public record ServerboundLandOnSpaceStationPacket(class_5321<class_1937> dimension, class_1923 spaceStationPos) implements Packet<ServerboundLandOnSpaceStationPacket>
{
    public static final ServerboundPacketType<ServerboundLandOnSpaceStationPacket> TYPE = new Type();

    public PacketType<ServerboundLandOnSpaceStationPacket> type() {
        return TYPE;
    }

    private static boolean isAllowed(class_3222 player, class_3218 level, class_1923 targetPos) {
        HashSet<SpaceStation> stations = new HashSet<SpaceStation>(SpaceStationHandler.getOwnedSpaceStations(player, level));
        if (!ArgonautsIntegration.argonautsLoaded()) {
            return stations.stream().anyMatch(station -> station.position().equals((Object)targetPos));
        }
        for (GameProfile member : ArgonautsIntegration.getClientPartyMembers(player.method_5667())) {
            stations.addAll(SpaceStationHandler.getOwnedSpaceStations(member.getId(), level));
        }
        for (GameProfile member : ArgonautsIntegration.getClientGuildMembers(player.method_5667())) {
            stations.addAll(SpaceStationHandler.getOwnedSpaceStations(member.getId(), level));
        }
        return stations.stream().anyMatch(station -> station.position().equals((Object)targetPos));
    }

    private static class Type
    extends CodecPacketType<ServerboundLandOnSpaceStationPacket>
    implements ServerboundPacketType<ServerboundLandOnSpaceStationPacket> {
        public Type() {
            super(ServerboundLandOnSpaceStationPacket.class, new class_2960("ad_astra", "land_on_space_station"), ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.DIMENSION.fieldOf(ServerboundLandOnSpaceStationPacket::dimension), (ObjectEntryByteCodec)ExtraByteCodecs.CHUNK_POS.fieldOf(ServerboundLandOnSpaceStationPacket::spaceStationPos), ServerboundLandOnSpaceStationPacket::new));
        }

        public Consumer<class_1657> handle(ServerboundLandOnSpaceStationPacket packet) {
            return player -> {
                class_1937 patt2688$temp = player.method_37908();
                if (!(patt2688$temp instanceof class_3218)) {
                    return;
                }
                class_3218 serverLevel = (class_3218)patt2688$temp;
                if (!(player instanceof class_3222)) {
                    return;
                }
                class_3222 serverPlayer = (class_3222)player;
                Planet planet = PlanetApi.API.getPlanet(packet.dimension);
                if (planet == null) {
                    return;
                }
                class_3218 targetLevel = serverLevel.method_8503().method_3847(planet.dimension());
                if (targetLevel == null) {
                    return;
                }
                if (!PlanetApi.API.isSpace((class_1937)targetLevel)) {
                    return;
                }
                if (!ModUtils.canTeleportToPlanet(player, planet)) {
                    return;
                }
                class_1923 targetPos = packet.spaceStationPos();
                if (!ServerboundLandOnSpaceStationPacket.isAllowed(serverPlayer, targetLevel, targetPos)) {
                    return;
                }
                class_2338 middleBlockPosition = targetPos.method_33943(AdAstraConfig.atmosphereLeave);
                ModUtils.land(serverPlayer, targetLevel, new class_243((double)((float)middleBlockPosition.method_10263() - 0.5f), (double)middleBlockPosition.method_10264(), (double)((float)middleBlockPosition.method_10260() - 0.5f)));
            };
        }
    }
}

